// $Header: /devl/xcs/repo/env/Databases/CAEInterfaces/verunilibs/data/rainier/RAMB36.v,v 1.16 2007/06/15 20:58:41 wloo Exp $
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 1995/2005 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor : Xilinx
// \   \   \/     Version : 10.1
//  \   \         Description : Xilinx Functional Simulation Library Component
//  /   /                  32K-Bit Data and 4K-Bit Parity Dual Port Block RAM
// /___/   /\     Filename : RAMB36.v
// \   \  /  \    Timestamp : Tues July 26 16:43:59 PST 2005
//  \___\/\___\
//
// Revision:
//    07/26/05 - Initial version.
//    01/04/07 - Added support of memory file to initialize memory and parity (CR 431584).
//    03/14/07 - Removed attribute INITP_FILE (CR 436003).
//    04/03/07 - Changed INIT_FILE = "NONE" as default (CR 436812).
//    06/13/07 - Added high performace version of the model.
// End Revision

`timescale 1 ps/1 ps

module RAMB36 (CASCADEOUTLATA, CASCADEOUTLATB, CASCADEOUTREGA, CASCADEOUTREGB, DOA, DOB, DOPA, DOPB,
	       ADDRA, ADDRB, CASCADEINLATA, CASCADEINLATB, CASCADEINREGA, CASCADEINREGB, CLKA, CLKB, DIA, DIB, DIPA, DIPB, ENA, ENB, REGCEA, REGCEB, SSRA, SSRB, WEA, WEB);
    
    parameter integer DOA_REG = 0;
    parameter integer DOB_REG = 0;
    parameter INITP_00 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_01 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_02 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_03 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_04 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_05 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_06 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_07 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_08 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_09 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_0A = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_0B = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_0C = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_0D = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_0E = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_0F = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_00 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_01 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_02 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_03 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_04 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_05 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_06 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_07 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_08 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_09 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_0A = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_0B = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_0C = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_0D = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_0E = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_0F = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_10 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_11 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_12 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_13 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_14 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_15 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_16 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_17 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_18 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_19 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_1A = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_1B = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_1C = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_1D = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_1E = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_1F = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_20 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_21 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_22 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_23 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_24 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_25 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_26 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_27 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_28 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_29 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_2A = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_2B = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_2C = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_2D = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_2E = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_2F = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_30 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_31 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_32 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_33 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_34 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_35 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_36 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_37 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_38 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_39 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_3A = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_3B = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_3C = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_3D = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_3E = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_3F = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_40 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_41 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_42 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_43 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_44 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_45 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_46 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_47 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_48 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_49 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_4A = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_4B = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_4C = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_4D = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_4E = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_4F = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_50 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_51 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_52 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_53 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_54 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_55 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_56 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_57 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_58 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_59 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_5A = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_5B = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_5C = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_5D = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_5E = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_5F = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_60 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_61 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_62 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_63 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_64 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_65 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_66 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_67 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_68 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_69 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_6A = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_6B = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_6C = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_6D = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_6E = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_6F = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_70 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_71 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_72 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_73 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_74 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_75 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_76 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_77 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_78 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_79 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_7A = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_7B = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_7C = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_7D = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_7E = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_7F = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_A = 36'h0;
    parameter INIT_B = 36'h0;
    parameter INIT_FILE = "NONE";
    parameter RAM_EXTENSION_A = "NONE";
    parameter RAM_EXTENSION_B = "NONE";
    parameter integer READ_WIDTH_A = 0;
    parameter integer READ_WIDTH_B = 0;
    parameter SIM_COLLISION_CHECK = "ALL";
    parameter SIM_MODE = "SAFE";
    parameter SRVAL_A = 36'h0;
    parameter SRVAL_B = 36'h0;
    parameter WRITE_MODE_A = "WRITE_FIRST";
    parameter WRITE_MODE_B = "WRITE_FIRST";
    parameter integer WRITE_WIDTH_A = 0;
    parameter integer WRITE_WIDTH_B = 0;

    localparam SETUP_ALL = 1000;
    localparam SETUP_READ_FIRST = 3000;
    
    output CASCADEOUTLATA, CASCADEOUTREGA;
    output CASCADEOUTLATB, CASCADEOUTREGB;
    output [31:0] DOA;
    output [31:0] DOB;
    output [3:0] DOPA;
    output [3:0] DOPB;
    
    input ENA, CLKA, SSRA, CASCADEINLATA, CASCADEINREGA, REGCEA;
    input ENB, CLKB, SSRB, CASCADEINLATB, CASCADEINREGB, REGCEB;
    input [15:0] ADDRA;
    input [15:0] ADDRB;
    input [31:0] DIA;
    input [31:0] DIB;
    input [3:0] DIPA;
    input [3:0] DIPB;
    input [3:0] WEA;
    input [3:0] WEB;

    tri0 GSR = glbl.GSR;

    wire [7:0] dangle_out8;
    wire dangle_out;
    wire [3:0] dangle_out4;
    wire [31:0] dangle_out32;

    ARAMB36_INTERNAL INT_RAMB (.DIA({32'b0,DIA}), .ENA(ENA), .WEA({4'b0,WEA}), .SSRA(SSRA), .ADDRA(ADDRA), .CLKA(CLKA), .DOA({dangle_out32,DOA}), .DIB({32'b0,DIB}), .ENB(ENB), .WEB({4'b0,WEB}), .SSRB(SSRB), .ADDRB(ADDRB), .CLKB(CLKB), .DOB(DOB), .GSR(GSR), .DOPA({dangle_out4,DOPA}), .DOPB(DOPB), .DIPA(DIPA), .DIPB({4'b0,DIPB}), .CASCADEOUTLATA(CASCADEOUTLATA), .CASCADEOUTLATB(CASCADEOUTLATB), .CASCADEOUTREGA(CASCADEOUTREGA), .CASCADEOUTREGB(CASCADEOUTREGB), .CASCADEINLATA(CASCADEINLATA), .CASCADEINLATB(CASCADEINLATB), .CASCADEINREGA(CASCADEINREGA), .CASCADEINREGB(CASCADEINREGB), .REGCEA(REGCEA), .REGCEB(REGCEB), .REGCLKA(CLKA), .REGCLKB(CLKB), .DBITERR(dangle_out), .ECCPARITY(dangle_out8), .SBITERR(dangle_out));

    defparam INT_RAMB.BRAM_MODE = "TRUE_DUAL_PORT";
    defparam INT_RAMB.INIT_A = INIT_A;
    defparam INT_RAMB.INIT_B = INIT_B;
    defparam INT_RAMB.INIT_FILE = INIT_FILE;
    defparam INT_RAMB.SRVAL_A = SRVAL_A;
    defparam INT_RAMB.SRVAL_B = SRVAL_B;
    defparam INT_RAMB.READ_WIDTH_A = READ_WIDTH_A;
    defparam INT_RAMB.READ_WIDTH_B = READ_WIDTH_B;
    defparam INT_RAMB.WRITE_WIDTH_A = WRITE_WIDTH_A;
    defparam INT_RAMB.WRITE_WIDTH_B = WRITE_WIDTH_B;
    defparam INT_RAMB.WRITE_MODE_A = WRITE_MODE_A;
    defparam INT_RAMB.WRITE_MODE_B = WRITE_MODE_B;
    defparam INT_RAMB.RAM_EXTENSION_A = RAM_EXTENSION_A;
    defparam INT_RAMB.RAM_EXTENSION_B = RAM_EXTENSION_B;
    defparam INT_RAMB.SETUP_ALL = SETUP_ALL;
    defparam INT_RAMB.SETUP_READ_FIRST = SETUP_READ_FIRST;
    defparam INT_RAMB.SIM_COLLISION_CHECK = SIM_COLLISION_CHECK;
    defparam INT_RAMB.SIM_MODE = SIM_MODE;
    defparam INT_RAMB.EN_ECC_READ = "FALSE";
    defparam INT_RAMB.EN_ECC_SCRUB = "FALSE";
    defparam INT_RAMB.EN_ECC_WRITE = "FALSE";
    defparam INT_RAMB.DOA_REG = DOA_REG;
    defparam INT_RAMB.DOB_REG = DOB_REG;
    defparam INT_RAMB.INIT_00 = INIT_00;
    defparam INT_RAMB.INIT_01 = INIT_01;
    defparam INT_RAMB.INIT_02 = INIT_02;
    defparam INT_RAMB.INIT_03 = INIT_03;
    defparam INT_RAMB.INIT_04 = INIT_04;
    defparam INT_RAMB.INIT_05 = INIT_05;
    defparam INT_RAMB.INIT_06 = INIT_06;
    defparam INT_RAMB.INIT_07 = INIT_07;
    defparam INT_RAMB.INIT_08 = INIT_08;
    defparam INT_RAMB.INIT_09 = INIT_09;
    defparam INT_RAMB.INIT_0A = INIT_0A;
    defparam INT_RAMB.INIT_0B = INIT_0B;
    defparam INT_RAMB.INIT_0C = INIT_0C;
    defparam INT_RAMB.INIT_0D = INIT_0D;
    defparam INT_RAMB.INIT_0E = INIT_0E;
    defparam INT_RAMB.INIT_0F = INIT_0F;
    defparam INT_RAMB.INIT_10 = INIT_10;
    defparam INT_RAMB.INIT_11 = INIT_11;
    defparam INT_RAMB.INIT_12 = INIT_12;
    defparam INT_RAMB.INIT_13 = INIT_13;
    defparam INT_RAMB.INIT_14 = INIT_14;
    defparam INT_RAMB.INIT_15 = INIT_15;
    defparam INT_RAMB.INIT_16 = INIT_16;
    defparam INT_RAMB.INIT_17 = INIT_17;
    defparam INT_RAMB.INIT_18 = INIT_18;
    defparam INT_RAMB.INIT_19 = INIT_19;
    defparam INT_RAMB.INIT_1A = INIT_1A;
    defparam INT_RAMB.INIT_1B = INIT_1B;
    defparam INT_RAMB.INIT_1C = INIT_1C;
    defparam INT_RAMB.INIT_1D = INIT_1D;
    defparam INT_RAMB.INIT_1E = INIT_1E;
    defparam INT_RAMB.INIT_1F = INIT_1F;
    defparam INT_RAMB.INIT_20 = INIT_20;
    defparam INT_RAMB.INIT_21 = INIT_21;
    defparam INT_RAMB.INIT_22 = INIT_22;
    defparam INT_RAMB.INIT_23 = INIT_23;
    defparam INT_RAMB.INIT_24 = INIT_24;
    defparam INT_RAMB.INIT_25 = INIT_25;
    defparam INT_RAMB.INIT_26 = INIT_26;
    defparam INT_RAMB.INIT_27 = INIT_27;
    defparam INT_RAMB.INIT_28 = INIT_28;
    defparam INT_RAMB.INIT_29 = INIT_29;
    defparam INT_RAMB.INIT_2A = INIT_2A;
    defparam INT_RAMB.INIT_2B = INIT_2B;
    defparam INT_RAMB.INIT_2C = INIT_2C;
    defparam INT_RAMB.INIT_2D = INIT_2D;
    defparam INT_RAMB.INIT_2E = INIT_2E;
    defparam INT_RAMB.INIT_2F = INIT_2F;
    defparam INT_RAMB.INIT_30 = INIT_30;
    defparam INT_RAMB.INIT_31 = INIT_31;
    defparam INT_RAMB.INIT_32 = INIT_32;
    defparam INT_RAMB.INIT_33 = INIT_33;
    defparam INT_RAMB.INIT_34 = INIT_34;
    defparam INT_RAMB.INIT_35 = INIT_35;
    defparam INT_RAMB.INIT_36 = INIT_36;
    defparam INT_RAMB.INIT_37 = INIT_37;
    defparam INT_RAMB.INIT_38 = INIT_38;
    defparam INT_RAMB.INIT_39 = INIT_39;
    defparam INT_RAMB.INIT_3A = INIT_3A;
    defparam INT_RAMB.INIT_3B = INIT_3B;
    defparam INT_RAMB.INIT_3C = INIT_3C;
    defparam INT_RAMB.INIT_3D = INIT_3D;
    defparam INT_RAMB.INIT_3E = INIT_3E;
    defparam INT_RAMB.INIT_3F = INIT_3F;
    defparam INT_RAMB.INIT_40 = INIT_40;
    defparam INT_RAMB.INIT_41 = INIT_41;
    defparam INT_RAMB.INIT_42 = INIT_42;
    defparam INT_RAMB.INIT_43 = INIT_43;
    defparam INT_RAMB.INIT_44 = INIT_44;
    defparam INT_RAMB.INIT_45 = INIT_45;
    defparam INT_RAMB.INIT_46 = INIT_46;
    defparam INT_RAMB.INIT_47 = INIT_47;
    defparam INT_RAMB.INIT_48 = INIT_48;
    defparam INT_RAMB.INIT_49 = INIT_49;
    defparam INT_RAMB.INIT_4A = INIT_4A;
    defparam INT_RAMB.INIT_4B = INIT_4B;
    defparam INT_RAMB.INIT_4C = INIT_4C;
    defparam INT_RAMB.INIT_4D = INIT_4D;
    defparam INT_RAMB.INIT_4E = INIT_4E;
    defparam INT_RAMB.INIT_4F = INIT_4F;
    defparam INT_RAMB.INIT_50 = INIT_50;
    defparam INT_RAMB.INIT_51 = INIT_51;
    defparam INT_RAMB.INIT_52 = INIT_52;
    defparam INT_RAMB.INIT_53 = INIT_53;
    defparam INT_RAMB.INIT_54 = INIT_54;
    defparam INT_RAMB.INIT_55 = INIT_55;
    defparam INT_RAMB.INIT_56 = INIT_56;
    defparam INT_RAMB.INIT_57 = INIT_57;
    defparam INT_RAMB.INIT_58 = INIT_58;
    defparam INT_RAMB.INIT_59 = INIT_59;
    defparam INT_RAMB.INIT_5A = INIT_5A;
    defparam INT_RAMB.INIT_5B = INIT_5B;
    defparam INT_RAMB.INIT_5C = INIT_5C;
    defparam INT_RAMB.INIT_5D = INIT_5D;
    defparam INT_RAMB.INIT_5E = INIT_5E;
    defparam INT_RAMB.INIT_5F = INIT_5F;
    defparam INT_RAMB.INIT_60 = INIT_60;
    defparam INT_RAMB.INIT_61 = INIT_61;
    defparam INT_RAMB.INIT_62 = INIT_62;
    defparam INT_RAMB.INIT_63 = INIT_63;
    defparam INT_RAMB.INIT_64 = INIT_64;
    defparam INT_RAMB.INIT_65 = INIT_65;
    defparam INT_RAMB.INIT_66 = INIT_66;
    defparam INT_RAMB.INIT_67 = INIT_67;
    defparam INT_RAMB.INIT_68 = INIT_68;
    defparam INT_RAMB.INIT_69 = INIT_69;
    defparam INT_RAMB.INIT_6A = INIT_6A;
    defparam INT_RAMB.INIT_6B = INIT_6B;
    defparam INT_RAMB.INIT_6C = INIT_6C;
    defparam INT_RAMB.INIT_6D = INIT_6D;
    defparam INT_RAMB.INIT_6E = INIT_6E;
    defparam INT_RAMB.INIT_6F = INIT_6F;
    defparam INT_RAMB.INIT_70 = INIT_70;
    defparam INT_RAMB.INIT_71 = INIT_71;
    defparam INT_RAMB.INIT_72 = INIT_72;
    defparam INT_RAMB.INIT_73 = INIT_73;
    defparam INT_RAMB.INIT_74 = INIT_74;
    defparam INT_RAMB.INIT_75 = INIT_75;
    defparam INT_RAMB.INIT_76 = INIT_76;
    defparam INT_RAMB.INIT_77 = INIT_77;
    defparam INT_RAMB.INIT_78 = INIT_78;
    defparam INT_RAMB.INIT_79 = INIT_79;
    defparam INT_RAMB.INIT_7A = INIT_7A;
    defparam INT_RAMB.INIT_7B = INIT_7B;
    defparam INT_RAMB.INIT_7C = INIT_7C;
    defparam INT_RAMB.INIT_7D = INIT_7D;
    defparam INT_RAMB.INIT_7E = INIT_7E;
    defparam INT_RAMB.INIT_7F = INIT_7F;
    defparam INT_RAMB.INITP_00 = INITP_00;
    defparam INT_RAMB.INITP_01 = INITP_01;
    defparam INT_RAMB.INITP_02 = INITP_02;
    defparam INT_RAMB.INITP_03 = INITP_03;
    defparam INT_RAMB.INITP_04 = INITP_04;
    defparam INT_RAMB.INITP_05 = INITP_05;
    defparam INT_RAMB.INITP_06 = INITP_06;
    defparam INT_RAMB.INITP_07 = INITP_07;
    defparam INT_RAMB.INITP_08 = INITP_08;
    defparam INT_RAMB.INITP_09 = INITP_09;
    defparam INT_RAMB.INITP_0A = INITP_0A;
    defparam INT_RAMB.INITP_0B = INITP_0B;
    defparam INT_RAMB.INITP_0C = INITP_0C;
    defparam INT_RAMB.INITP_0D = INITP_0D;
    defparam INT_RAMB.INITP_0E = INITP_0E;
    defparam INT_RAMB.INITP_0F = INITP_0F;

    specify

        (CLKA => DOA[0]) = (100, 100);
        (CLKA => DOA[1]) = (100, 100);
        (CLKA => DOA[2]) = (100, 100);
        (CLKA => DOA[3]) = (100, 100);
        (CLKA => DOA[4]) = (100, 100);
        (CLKA => DOA[5]) = (100, 100);
        (CLKA => DOA[6]) = (100, 100);
        (CLKA => DOA[7]) = (100, 100);
        (CLKA => DOA[8]) = (100, 100);
        (CLKA => DOA[9]) = (100, 100);
        (CLKA => DOA[10]) = (100, 100);
        (CLKA => DOA[11]) = (100, 100);
        (CLKA => DOA[12]) = (100, 100);
        (CLKA => DOA[13]) = (100, 100);
        (CLKA => DOA[14]) = (100, 100);
        (CLKA => DOA[15]) = (100, 100);
        (CLKA => DOA[16]) = (100, 100);
        (CLKA => DOA[17]) = (100, 100);
        (CLKA => DOA[18]) = (100, 100);
        (CLKA => DOA[19]) = (100, 100);
        (CLKA => DOA[20]) = (100, 100);
        (CLKA => DOA[21]) = (100, 100);
        (CLKA => DOA[22]) = (100, 100);
        (CLKA => DOA[23]) = (100, 100);
        (CLKA => DOA[24]) = (100, 100);
        (CLKA => DOA[25]) = (100, 100);
        (CLKA => DOA[26]) = (100, 100);
        (CLKA => DOA[27]) = (100, 100);
        (CLKA => DOA[28]) = (100, 100);
        (CLKA => DOA[29]) = (100, 100);
        (CLKA => DOA[30]) = (100, 100);
        (CLKA => DOA[31]) = (100, 100);
        (CLKA => DOPA[0]) = (100, 100);
        (CLKA => DOPA[1]) = (100, 100);
        (CLKA => DOPA[2]) = (100, 100);
        (CLKA => DOPA[3]) = (100, 100);
       
        (CLKB => DOB[0]) = (100, 100);
        (CLKB => DOB[1]) = (100, 100);
        (CLKB => DOB[2]) = (100, 100);
        (CLKB => DOB[3]) = (100, 100);
        (CLKB => DOB[4]) = (100, 100);
        (CLKB => DOB[5]) = (100, 100);
        (CLKB => DOB[6]) = (100, 100);
        (CLKB => DOB[7]) = (100, 100);
        (CLKB => DOB[8]) = (100, 100);
        (CLKB => DOB[9]) = (100, 100);
        (CLKB => DOB[10]) = (100, 100);
        (CLKB => DOB[11]) = (100, 100);
        (CLKB => DOB[12]) = (100, 100);
        (CLKB => DOB[13]) = (100, 100);
        (CLKB => DOB[14]) = (100, 100);
        (CLKB => DOB[15]) = (100, 100);
        (CLKB => DOB[16]) = (100, 100);
        (CLKB => DOB[17]) = (100, 100);
        (CLKB => DOB[18]) = (100, 100);
        (CLKB => DOB[19]) = (100, 100);
        (CLKB => DOB[20]) = (100, 100);
        (CLKB => DOB[21]) = (100, 100);
        (CLKB => DOB[22]) = (100, 100);
        (CLKB => DOB[23]) = (100, 100);
        (CLKB => DOB[24]) = (100, 100);
        (CLKB => DOB[25]) = (100, 100);
        (CLKB => DOB[26]) = (100, 100);
        (CLKB => DOB[27]) = (100, 100);
        (CLKB => DOB[28]) = (100, 100);
        (CLKB => DOB[29]) = (100, 100);
        (CLKB => DOB[30]) = (100, 100);
        (CLKB => DOB[31]) = (100, 100);
        (CLKB => DOPB[0]) = (100, 100);
        (CLKB => DOPB[1]) = (100, 100);
        (CLKB => DOPB[2]) = (100, 100);
        (CLKB => DOPB[3]) = (100, 100);
	
	(CASCADEINLATA => DOA[0]) = (0, 0);
	(CASCADEINREGA => DOA[0]) = (0, 0);
	(CASCADEINLATB => DOB[0]) = (0, 0);
	(CASCADEINREGB => DOB[0]) = (0, 0);
	(CLKA => CASCADEOUTLATA) = (100, 100);
	(CLKA => CASCADEOUTREGA) = (100, 100);
	(CLKB => CASCADEOUTLATB) = (100, 100);
	(CLKB => CASCADEOUTREGB) = (100, 100);

	specparam PATHPULSE$ = 0;

    endspecify

endmodule // RAMB36

    

